﻿New-PWLogin decide-pwce-us.bentley.com:decide-pwce-us-10 -BentleyIMS

$parent = "Connected Projects\0004"

$outputFile = "c:\temp\Decide15.xlsx"

Get-PWRichProjectReport -OutputFileName $outputFile -FolderPath ((Show-PWFolderBrowserDialog).FullPath)

#$storages = Get-PWStorageAreaList

#"Storage Areas:"
#$storages.ForEach({"$($_.Name)"})

#$projectTypes = Get-PWRichProjectTypes

#"Project Types:"
#$projectTypes.ForEach({"$($_.ClassName)"})

#$templates = Get-PWProjectTemplates

#"Templates:"
#$templates.ForEach({"$($_.Name)"})

Get-PWConnectedProjectDataLocations

Start-Process $outputFile

$newProjects = New-PWRichProjectsFromSpreadsheet -InputFileName C:\temp\Decide05.xlsx -DefaultStorageArea Storage -DefaultNewParentPath $parent `
     -DefaultTemplateName Generic -SkipFolderWorkflowSecurityReplication

#list the created folders
$newProjects.ForEach({"$($_.FullPath)"})

$wsgurl = "https://decide-pwce-us-ws.bentley.com/ws"

foreach ($rp in $newProjects) 
{
    write-host $rp.FullPath
    write-host $rp.ProjectID, $rp.ProjectProperties["PROJECT_Project_Name"], $rp.ProjectProperties["PROJECT_Project_Location"], $rp.ProjectProperties["PROJECT_Project_Number"]

    #$pname = $rp.ProjectProperties["PROJECT_Project_Name"] + "_" + (Get-RandomString -Length 8)
    $pname = $rp.ProjectProperties["PROJECT_Project_Name"]

    $connectedProjectId = Add-PWConnectedProject -InputFolder $rp -ConnectedProjectName $pname -ConnectedProjectNumber $pname -Location $rp.ProjectProperties["PROJECT_Project_Location"] -MakeUnique -DataLocation $rp.ProjectProperties["PROJECT_Project_Location"] -CountryCode GB -WSGURL $wsgurl -WSGVersion "2.8"

    write-host "Connected Project Page: https://connect.bentley.com/project/index?projectId=$connectedProjectId"
    write-host "Connections Page: https://projectshareportal.bentley.com/#/$connectedProjectId"
}

#Start-Process -FilePath ("https://projectshareportal.bentley.com/#/$connectedProjectId")

#put zip file in cloud


 