﻿$folderPath = (Show-PWFolderBrowserDialog).FullPath

$reportName = "c:\temp\PWDocReport02.xlsx"

#copy out file
$docs=Get-PWDocumentsBySearch -FolderPath $folderPath -FileName %.zip

CheckOut-PWDocuments $docs -CopyOut

$inputFile = $docs[0].CheckedOutLocalFileName

#import from zip
$imported=Import-PWDocumentsFromZip -InputFileName $inputFile -ParentPWFolderPath $folderPath -StorageArea Storage -Environment Complex

#Apply attributes
Update-PWDocumentAttributes $imported -Attributes @{Remarks = "Default Value"}

#get report
Save-PWDocumentReport -ProjectWiseFolder $folderPath -OutputFileName $reportName -Recurse

#update report with desired attributes

Start-Process $reportName

#set attributes
#$changedDocs = Import-PWDocumentsBySpreadsheet -InputFile $reportName -OnlyUpdateAttributes -SkipAuditTrail -DefaultStorage Storage

