﻿$logfilePath = "c:\temp"
$logfile = "$logfilePath\ScanRef20190104b.log"

#   -d datasource    Datasource name to connect to.
$dsname = 'decide-pwce-us.bentley.com:decide-pwce-us-10'

$folderPath = (Show-PWFolderBrowserDialog).FullPath

#   -masterfolders folderlist   A list of folders to scan for references and/or linksets. "r:" prefix means recursive
$masterfolders = "r:$folderPath"

#   -priority folderlist    Enable priority search for reference files in the specified folders.
#                  Prefix folder path with "r:" to recurse through the folder and sub-folders.  
#                  NOTE: Ensure the folder path does NOT end with a backslash "\". This will cause an error.
#                  NOTE: Do not add spaces between folder paths. This will cause an error.
$priority = "r:$folderPath"


# The following retrieves the ProjectWise path information from the registry.
$execpath = Get-PWPath

# Stops processing if the path information is not found.
if([string]::IsNullOrEmpty($execpath)) {
    Write-Error("Failed to get ProjectWise path.")
    return;
} 

# Verify the scanrefs executable exists on the current machine. Stops processing if not found.

$executable = ((Get-PWPath) + "\scanrefs.exe")

if(-not (Test-Path -Path $executable))
{
    Write-Error ("Could not find " + $executable)
    return;
} else {
    "Found scanrefs.exe file."
}

#  -mode scanmode  Specifies a list of scanning modes to use.
#   If this option is absent, the tool will operate in "references;linksets" mode.
#
#   Possible modes:
#     references - scan for references.
#     linksets   - scan DGN documents for link sets.
#     urfcs      - update references from current set - no attempt will be made at creating new sets,
#                  only existing reference sets will be updated.
#                  If this mode is enabled, priority or proximity reference search paths will be ignored.
#                  This option is intended to be used after upgrading a datasource from a pre-V8.1 version.
#                    Note that this mode disables other modes.
#     Modes can be combined:
#                  references;linksets - scan for reference documents and for DGN link sets.
#                  NOTE: Do not add spaces between mode labels. This will cause an error (Unrecognized scanning mode:)
$scanmode = 'references'

#   -masters documentlist    A list of documents to scan for references and/or linksets.
$masterdocuments = ""

#   -proximity [r:]number   Enable proximity search for reference files <number> levels above the master file's folder.
#                  r: switch enables recursive search (includes subfolders).
#                  Examples:
#                     -proximity 0   - look for references in the master's folder.
#                     -proximity 1   - look for references in the parent folder of the master.
#                     -proximity r:1 - look for references in the master's folder's parent folder and its subfolders.
$proximity = "r:0"

#   -order orderlist        Order in which the proximity and priority searches will be done (if both are enabled).
#                  If this parameter is not specified, proximity search will take precedence.
#                  Examples:
#                     -order proximity;priority - proximity first.
#                     -order priority;proximity - priority first.
#                  NOTE: Do not add spaces between order label. This will cause an error (Input error: Unknown search type:).
$order = "priority;proximity"
#$order = "proximity"

#   -af applicationlist     Application filter for the lists of documents to scan - only the documents with matching application names will be scanned.
#                  Example: 
#                     -af "MicroStation;AutoCad;Bentley Navigator"
#                  NOTE: This is case sensitive, so ensure the names are listed exactly as they are in ProjectWise Administrator.
#                  NOTE: Do not add spaces between application names. This will cause an error (Collecting data...  Failure).
$applications = "AutoCAD;MicroStation"

#   -l logfile              Log file path.

#   -lv           Use verbose logging - write more details to the log file.


# Test to determine if the log folder exists. If not, create.
if(-not (Test-Path -Path $logfilePath)) {
    New-Item -Path $logfilePath -ItemType "directory"
}

# the ampersand (&) is the "call" operator which allows you to execute a command, a script, or a function.
& $executable -d $dsname -mode $scanmode -masterfolders $masterfolders -af $applications -priority $priority -proximity $proximity -order $order -l $logfile -lv

# Opens log file
explorer $logfile
