﻿$folderPath = (Show-PWFolderBrowserDialog).FullPath

#cleanup 
$docsToDelete = Get-PWDocumentsBySearch -FolderPath ($folderPath + "\Drawings\") -FileName %.pdf

Remove-PWDocuments $docsToDelete


$docsToPlot = Get-PWDocumentsBySearch -FolderPath ($folderPath + "\Drawings\") -FileName %.dgn

#Get-PWRenditionProfiles

$plottedDocs = New-PWRenditionRequest $docsToPlot -ProfileName 'PDF to PDF Sub-Folder' -MakeSinglePlotRequest

do 
{
Write-Verbose "Pause..."
Start-Sleep -Seconds 30
$docsToTransmit = Get-PWDocumentsBySearch -FolderPath ($folderPath + "\Drawings\") -FileName %.pdf
} while ($docsToTransmit.Length -lt $docsToPlot.Length)

$connectedProjectGuid = Get-PWFolders -FolderPath $folderPath -JustOne | Get-PWConnectedProjectId

New-PWDMTransmittal $docsToTransmit -ConnectedProjectId $connectedProjectGuid -SendToEmails `
    "dave.brumbaugh@bentley.com","dave.brumbaugh@eagle.bentley.com"
