﻿# ProjectWise Folder containing the documents to update.
$PWFolder = 'PowerShell\Update Documents'
# Get document objects to update attributes.
$PWDocuments = Get-PWDocumentsBySearch -FolderPath $PWFolder -Verbose

# Index to track which document we are processing.
$Index = 0
# Loop through each of the ProjectWise Documents and update the document attributes.
foreach ($PWDocument in $PWDocuments) {
    <# Specify attribute values
            The Discipline attribute value will be the same for all documents. #>
    $Attributes = @{
        Discipline = 'RoadDesign'
    }
    
    <# The MileStone and TB_PERCENT_COMPLETE attribute values will be the same
            for first and third documents and second and fourth documents. #>
    if($Index -eq 0 -or $Index -eq 2) {
        $Attributes.MileStone = 'Open'
        $Attributes.TB_PERCENT_COMPLETE = '20'
    } else {
        $Attributes.MileStone = 'ExportFromProjectWise'
        $Attributes.TB_PERCENT_COMPLETE = '90'
    }  

    <# By returning the boolean, we can use a simple if else to write back to the
       console whether the process was successful or not. #>
    if( Update-PWDocumentAttributes -InputDocuments $PWDocument -Attributes $Attributes -ReturnBoolean ) {
        Write-Verbose -Message "Successfully updated the document attributes for '$($PWDocument.Name)'." -Verbose
    } else {
        # Could be an error or warning here.
        Write-Warning -Message "Failed to update the document attributes for '$($PWDocument.Name)'."
    }
    
    # Increment the index value by one.
    $Index++
}
