﻿# Project Folder to search for documents.
$PWFolder = 'PowerShell\PowerShell_Test'
# Output file name.
$OutputFile = 'd:\temp\export\DuplicateDocuments.xlsx'
# Get Documents to check for duplicates.
$pwDocuments = Get-PWDocumentsBySearch -FolderPath $PWFolder # -GetAttributes (Using the GetAttributes switch takes to long to complete.)

# Stop processing if no documents are returned.
if($pwDocuments.Count -lt 1) {
    Write-Warning -Message "No documents returned." -Verbose
    break
}

# Temporary array to help facilitate finding duplicate documents.
$pwDocuments_Temp = New-Object System.Collections.ArrayList
# Array to store duplicate document names.
$pwDocuments_DuplicateNames = New-Object System.Collections.ArrayList

# Loop through all documents and find any duplicate document names.
foreach ($pwDocument in $pwDocuments) {      
    if( -not ($pwDocuments_Temp.Contains($pwDocument.Name))) {
        $pwDocuments_Temp.Add($pwDocument.Name) | Out-Null
    } else {
        $pwDocuments_DuplicateNames.Add($pwDocument.Name) | Out-Null
    } 
} # end foreach ($pwDocument...

# Remove the $pwDocuments_Temp variable.
Remove-Variable pwDocuments_Temp

if($pwDocuments_DuplicateNames.Count -gt 0) { 

    # Convert PWDocuments to a datatable for ability to use the .Select method.
    $dtDuplicates = Convert-ObjectArrayToDataTable -InputObjectArray ($pwDocuments | 
                        Where-Object Name -In $pwDocuments_DuplicateNames)

    # Create new datatable to be exported to Excel.
    $dt = New-Object System.Data.DataTable ('Duplicates')
    $dt.Columns.Add("DocumentName") | Out-Null
    $dt.Columns.Add("FullPath") | Out-Null

    <# Loop through each duplicate document name and populate new datatable
        With the document name and fullpath. #> 
    foreach ($duplicate in $pwDocuments_DuplicateNames) {    
        $temp = $dtDuplicates.Select("Name = '$duplicate'")
    
        foreach ($item in $temp) {
            #$pwDocs_Dupes.Add($item) | Out-Null
            $dr = $dt.NewRow()
        
            $dr.DocumentName = $item.Name
            
            # Get fullpath for current document ($item).
            $Splat = @{
                FolderID = $item.ProjectID
                DocumentName = $item.Name
            }          
            $pwDoc = Get-PWDocumentsBySearch @Splat -GetAttributes -JustThisFolder
            $dr.FullPath = $pwDoc.FullPath
        
            $dt.Rows.Add($dr)
        } 
    } # end foreach ($duplicate...
} # end if($pwDocuments_DuplicateNames.Count...

if($dt.ROws.Count -gt 0) { 
    # Export datatable to Excel workbook.
    New-XLSXWorkbook -InputTables $dt -OutputFileName $OutputFile
}
