
# Creates a new ArrayList to be populated with the numbers 1 - 100.
$arrayList_OutNull = New-Object System.Collections.ArrayList

# A simple example of populating an ArrayList
1 .. 100 | ForEach-Object { $arrayList.Add($_) | Out-Null }

Measure-Command {
	$arrayList_Variable = New-Object System.Collections.ArrayList
	
	# A simple example of populating an ArrayList
	1 .. 100 | ForEach-Object { $null = $arrayList.Add($_) }
}



# Get average times for each scenario.
[int] $NumberOfTimesToRun = 10
[double] $total_OutNull = 0
[double] $total_Variable = 0

for ($x = 0; $x -lt $NumberOfTimesToRun; $x++) {
	$results_OutNull = Measure-Command {
		# Creates a new ArrayList to be populated with the numbers 1 - 100.
		$arrayList = New-Object System.Collections.ArrayList
		
		# A simple example of populating an ArrayList
		1 .. 100 | ForEach-Object { $arrayList.Add($_) | Out-Null }
	}
	$total_OutNull += $results_OutNull.TotalMilliseconds
	
	$results_Variable = Measure-Command {
		# Creates a new ArrayList to be populated with the numbers 1 - 100.
		$arrayList = New-Object System.Collections.ArrayList
		
		# A simple example of populating an ArrayList
		1 .. 100 | ForEach-Object { $null = $arrayList.Add($_) }
	}
	$total_Variable += $results_Variable.TotalMilliseconds
}

$average_OutNull = $total_OutNull / $NumberOfTimesToRun
$average_Variable = $total_Variable / $NumberOfTimesToRun
