# Local folder to work in.
$Path = 'D:\TEMP\References'

# ProjectWise datasource information to be used with Scan for References.
$Target_Datasource = 'bmf-ws2016-pwdi:PowerShell'
$Target_UserName = 'pwadmin'

# Path and name to the encrypted password file.
# Use the following to create the required secure password file.
# Save-SecureStringToEncryptedFile -FileName $Target_PasswordFilePathName -Prompt "EnterPassword"
# Ensure the path exists. Otherwise you will receive an error.
<# You can create the folder using:
        New-Item -Path D:\TEMP\References -ItemType Directory
#>
$Target_PasswordFilePathName = "$Path\securePassword.txt"

# Folder path to original (Source) Work Area / Project.
$FolderPath = 'BSI900 - Adelaide Tower'

# ProjectWise folder to import archived project into within the Target ProjectWise Datasource.
$TargetProjectWiseFolder = 'Projects'
# Storage area to be used with the import process.
$DefaultStorage = "Storage01"

# File path and name of reference report to be generated.
# Adding the date to the report name to ensure a unique name.
$Date = Get-Date -Format yyyyMMddHHmmss
$outputFilePathName = "$Path\ReferenceReport_$Date.xlsx"

# Archive file name.
$OutputFileName = "$($FolderPath)_$Date.sqlite"

#region Log into Source Datasource to generate reference report.

try {
    $Splat_ReferenceReport = @{
        FolderPath = $FolderPath
        OutputFilePath = $outputFilePathName
    }
    # Using the $null variable to suppress the reference information from being presented in the console.
    $null = Get-PWReferenceReportForFolder @Splat_ReferenceReport -ErrorAction Stop
} catch {
    Write-Warning -Message "$($Error[0].Exception.Message)"
}

#endregion Log into Source Datasource to generate reference report.

#region Export project from Source Datasource to SQLite database.

$Splat_Export = @{
    ProjectWiseFolder = $FolderPath
    OutputFolder = $Path
    OutputFileName = $OutputFileName
}
Export-PWDocumentsToArchive @Splat_Export

#endregion Export project from Source Datasource to SQLite database.

#region Import project into Target Datasource from SQLite database.

$Splat_Import = @{
    InputFile = "$Path\$OutputFileName"
    TargetProjectWiseFolder = $TargetProjectWiseFolder
    DefaultStorage = $DefaultStorage
}
Import-PWDocumentsFromArchive @Splat_Import

#endregion Import project into Target Datasource from SQLite database.


Import-Module "D:\PowerShell\!Blog Post Scripts\ScanForReferencesFromReport\FUNCTION_ScanReferencesFromReport.psm1" -Force -Verbose

Get-Command New-PWScanRefFromReport

# Update reference relationships from reference report.
$Splat_ProcessReport = @{
    DatasourceName = $Target_Datasource
    UserName = $Target_UserName
    PasswordFilePathName = $Target_PasswordFilePathName
    ReportPathName	     = $outputFilePathName
    TargetProjectWiseFolder = $TargetProjectWiseFolder
}
New-PWScanRefFromReport @Splat_ProcessReport -verbose	
