﻿FUNCTION Get-PWCommands {
    <#
            .SYNOPSIS
            Used to get ONLY commands contained in the PWPS_DAB module.
            .DESCRIPTION
            Returns ONLY commands related to the PWPS_DAB module. 
            .EXAMPLE
            # Returns all commands delivered with the PWPS_DAB module.
            Get-PWCommands -Verbose
            # Returns all commands with the word userlist in the cmdlet name.
            Get-PWCommands -Name 'userlist'
            # Returns all commands with the word Get in the verb portion of the cmdlet name.
            Get-PWCommands -Verb 'get'
            # Returns all commands with the word group in the noun portion of the cmdlet name.
            Get-PWCommands -Noun 'group'
            # Returns all commands with the word update in the verb portion of the cmdlet name and user in the noun portion of the cmdlet name.
            Get-PWCommands -Verb update -Noun user
    #>
                          
    [CmdletBinding()]
    param (
        [ValidateNotNullOrEmpty()]
        [Parameter(
				Position = 0,
            HelpMessage = "Specifies the name of the PowerShell cmdlet to search for.",
            Mandatory=$false)]
        [string] $Name,
        
        [ValidateNotNullOrEmpty()]
        [Parameter(
                HelpMessage = "Specifies the 'noun' within the PowerShell cmdlet name to search for.",
            Mandatory=$false)]
        [string] $Noun,
        
        # Specifies the ProjectWise folder to be used in saved search.
        [ValidateNotNullOrEmpty()]
        [Parameter(
                HelpMessage = "Specifies the 'verb' within the PowerShell cmdlet name to search for.",
            Mandatory=$false)]
        [string] $Verb
    ) # end param...

    BEGIN {
    } # end BEGIN...

    PROCESS {
    
        $Splat_GetCommand = @{
            Module = 'PWPS_DAB'
        }
        if( -not ([string]::IsNullOrEmpty($Name))) {
            $Splat_GetCommand.Name = "*$Name*"
        }
        if( -not ([string]::IsNullOrEmpty($Noun))) {
            $Splat_GetCommand.Noun = "*$Noun*"
        }
        if( -not ([string]::IsNullOrEmpty($Verb))) {
            $Splat_GetCommand.Verb = "*$Verb*"
        }
        
        $ReturnValue = Get-Command @Splat_GetCommand | Select-Object Name
    } # end PROCESS...

    END {
        Write-Output $ReturnValue
    } # end END...
} # end FUNCTION Get-PWCommands...
Export-ModuleMember Get-PWCommands
